/* intercep.h -- header file for intercep.c
 * typedefs, defaults, etc.
 * Ned Konz 8/1/87
 */

/* some syntactic sugar */
typedef void interrupt (far *IFP)();	/* pointer to interrupt function */
typedef IFP far *IFPP;			/* and pointer to those */

/* structure which makes up list of interrupts to capture */
typedef struct {
	int intnum;		/* which interrupt */
	IFP oldint;	/* old handler */
} Intblock;

/* structure which is left on stack after interrupt */
typedef struct {
	IFP ipcs;	/* IP, CS */
	unsigned flags;
} Intpack;

/* structure which is pushed onto stack by entry into
 * an interrupt function in Turbo C
 */
typedef struct {
	unsigned bp,  di,  si,  ds,  es, dx;
	union {
		unsigned old[3];	/* actually cx, bx, and ax */
		Intpack new;	/* where we will chain to */
	} ovl;
} Regpack;

/* what we record in our memory block about each interrupt */
typedef struct {
	Regpack regs;
	Intpack caller;
	int intnum;
} Swi_info;

/* some defaults */
#define MAX_INTS	30	/* maximum number of interrupt vectors */
#define MAX_INTERRUPTS	2500	/* about 64K (arbitrary) */
#define OFILENAME "intercep.out"	/* output file name */

#define OFILTER "interpre.exe"	/* output filter name */
#define TFILENAME "interpre.dat"	/* template file name */
